/**
 *
 * NMAIL.CPP - sucht im PMAIL-Verzeichnis des Users (Voreinstellung: U:\PMAIL)
 *             nach neuen Nachrichten (*.CNM) und zeigt davon die From: und
 *             Subject: Zeilen an.
 *
 * Ergebnis: Errorlevel
 * = 0 - keine neue Mail gefunden
 * = 1 - neue Mail gefunden
 *
 * Copyright Robert Glckner c/o Systeme Helmholz GmbH
 * Email: rgloeckner@helmholz.de
 * Fido: Robert Gloeckner, 2:2490/1050.84
 *
**/
#include <stdio.h>
#include <string.hpp>
#include <fstream.h>
#include <direct.h>
#include <i86.h>

extern "C" {
#include <user\getopt.h>
}

int quiet = 0, mailcount = 0;

String maildir("U:\\PMAIL");


int main (int ac, char ** av)
{
    int optch, err = 0;
    char * as = "qd:h";
    DIR * direntry;

    fprintf(stdout,"\nNMAIL - scans for newmail with PMAIL working in NDS mode. " __DATE__ "\n");
    fprintf(stdout,"  V1.0 - " __DATE__ " - rgloeckner@helmholz.de\n");

    while(!err && optind < ac) {
        if((optch = getopt(ac,av,as)) != EOF) {
            switch(optch) {
            case 'q' : quiet = !quiet;
                break;
            case 'd' : maildir = optarg;
                break;
            case 'h' :
                fprintf(stderr,"\n usage: nmail [options]\n");
                fprintf(stderr,"   options:\n");
                fprintf(stderr,"    -q      - toggle sound alarm/msg display\n");
                fprintf(stderr,"    -d path - use path instead of U:\\PMAIL\n");
                fprintf(stderr,"   returns errorlevel\n");
                fprintf(stderr,"    = 0 - no new mail\n");
                fprintf(stderr,"    = 1 - new mail arrived\n");
                return err;
                break;
            }
        }
        else optind++;
    }

    if(maildir[maildir.length()] != '\\')
        maildir += '\\';

    fprintf(stdout,"\nSearching for newmail in path\n  %s\n\n", (char const *) maildir.upper());

    direntry = opendir(maildir + "*.CNM");
    while(readdir(direntry) != NULL) {
        err = 1;
        mailcount++;
        if (!quiet) {
            String file = maildir+direntry->d_name;
//            printf("%s\n", (char const *) file);

            sound(2048); delay(200); sound(1024); delay(100); nosound();

            ifstream inf(file);
            char linebuf[256];
            while (!inf.eof())
            {
                inf.getline(linebuf, sizeof(linebuf));
                if(!inf.eof()) {
                  String line = linebuf;
                  if (line.index("From:") == 0 || line.index("Subject:") == 0)
                    printf("%s\n", (char const *) line);
                }
            }
            printf("\n");
        }
    }
    closedir(direntry);

        printf("%d new mails found\n", mailcount);

    return err;
}


