//
//  WPMPREFS.H
//  Definitions and constants for the Pegasus Mail for Windows
//  Extensions Manager interface preferences management calls.
//
//  Copyright (c) 1994, David Harris, all rights reserved.
//
//  Use the equates in this file to indicate to the extensions manager
//  which value you want to set or get in the user's preferences when you
//  use the WM_F_SETPREF or WM_F_GETPREF messages. In the list below is a
//  brief description of each field, and a description of the type of the
//  item using the following legend:
//
//     char * [x]    --  A C string which can be at most X chars long
//     B             --  A boolean value, where 1 = TRUE and 0 = FALSE.
//     x..x          --  A range of possible integer values
//     Integer       --  A signed 16-bit value
//     RECT *        --  A pointer to a Windows RECT structure
//     POINT *       --  A pointer to a Windows POINT structure
//     FONTDEF *     --  A Pointer to a FONTDEF structure (see below)
//
//  When calling WM_F_GETPREF, the function will return the value for
//  scalar types (Integer, boolean, long). For non-scalar types you
//  must pass a pointer to a structure of the proper size in the lParam
//  parameter to the message.
//
//  When calling WM_F_SETPREF, you should pass scalar types in the
//  lParam parameter, and pointers to all other types as lParam.
//
//  *** WARNING!!! ***
//  The onus is on you to ensure that you pass pointers to items of the
//  correct size, since WinPMail will not (cannot) check them in most
//  cases.
//

typedef struct
   {
   char fontname [32];     // LF_FACESIZE
   int fontsize, style;
   } FONTDEF;

#ifndef WINPMAIL
typedef struct
   {
   char fname [13];
   char sysfolder;
   char copy;
   } QUICKFOLDER;
#endif

enum
   {                        // -- Description -------------------- Type ------
   W_PRO_PERSONAL_NAME,     // User's Personal name setting        char * [46]
   W_PRO_DEFRMARGIN,        // Editor default right margin         1..256
   W_PRO_HOMEBOX,           // Home mailbox location               char * [46]
   W_PRO_COPYSELF,          // Copy self saved value               B
   W_PRO_SELFFOLDER,        // Copy-to-self folder (name only)     char * [14]
   W_PRO_COMMENT_WITH,      // Commenting string                   char * [14]
   W_PRO_COLLATION,         // Sort order for folders              B
   W_PRO_DEFAULT_REPLY = 9, // Default reply-to address            char * [46]
   W_PRO_REPLY,             // Default reply dialog settings       char * [9]
   W_PRO_EDIT_FORWARD,      // Edit before forwarding value        B
   W_PRO_MHS_NAME,          // MHS name-8 for this user            char * [30]
   W_PRO_RQC,               // Confirm reading saved value         B
   W_PRO_WORKDIR,           // Working (temporary) directory       char * [46]
   W_PRO_MHS_APP_DIR,       // User's preferred MHS application    char * [13]
   W_PRO_SCAN_MHS_DIR,      // Scan the "MHS" app. for newmail     B
   W_PRO_OPEN_NEW,          // Open newmail folder at startup      B
   W_PRO_SAVE_DELETED,      // Saved deleted mail until exit       B
   W_PRO_PROMPT_COPYSELF,   // Prompt for copy-to-self             B
   W_PRO_PROMPT_CSFOLDER,   // Prompt for copy-to-self folder      B
   W_PRO_LEAVE_NEW,         // Leave read mail in newmail folder   B
   W_PRO_ASORT,             // Address book sort setting           0, 1
   W_PRO_NEED_PASSWORD,     // Require NetWare passwd at startup   B
   W_PRO_SMF_NAME,          // User's MHS SMF-71 address           char * [128]
   W_PRO_USE_MIME,          // Whether or not to use MIME          B
   W_PRO_CHARSET,           // default MIME character set          char * [20]
   W_PRO_USE_PGP = 29,      // Not currently used                  B
   W_PRO_ENCRYPT_CS,        // Encrypt copyselfs of encrypted mail B
   W_PRO_NO_CONFIRM_DEL,    // Don't confirm deletions             B
   W_PRO_BULKMAIL,          // Prefer enclosures over attachments  B
   W_PRO_NB_COLLATION,      // Noticeboard sort order              0..4
   W_PRO_ATTACH_SCAN_LINES, // # lines to scan for attachments     Integer
   W_PRO_BPANELV,           // Button panel mode                   0, 1, 2
   W_PRO_BP_CLOSED,         // Button panel open state             B
   W_PRO_BP_RECT,           // Button panel position               RECT *
   W_PRO_NEWMAIL_RECT,      // Newmail folder position             RECT *
   W_PRO_NOSIG,             // Suppress message signatures         B
   W_PRO_DELIVERY,          // Request confirmation of delivery    B
   W_PRO_FRAME_MAX,         // Frame window is maximized at start  B
   W_PRO_FRAME_RECT,        // Frame window size                   RECT *
   W_PRO_ED_WH,             // Editor window height/width          POINT *
   W_PRO_RD_WH,             // Reader window height/width          POINT *
   W_PRO_READERFONT,        // Reader font definition              FONTDEF *
   W_PRO_EDMAILFONT,        // Editor font definition              FONTDEF *
   W_PRO_FOLDERFONT,        // Folder font definition              FONTDEF *
   W_PRO_PRINTERFONT,       // Printer font definition             FONTDEF *
   W_PRO_ADVANCED_REPLY,    // If NZ, use advanced reply dialog    B
   W_PRO_TBMARGIN,          // Printer top/bottom margin           Integer
   W_PRO_LRMARGIN,          // Printer left/right margin           Integer
   W_PRO_UL_RECT,           // Userlist window position            RECT *
   W_PRO_REFORMAT,          // Not currently used
   W_PRO_PR_DEVICE,         // Printer device                      char * [50]
   W_PRO_PR_DRIVER,         // Printer driver name                 char * [20]
   W_PRO_PR_PORT,           // Printer port                        char * [20]
   W_PRO_TABWIDTH,          // Tab width in editor                 Integer
   W_PRO_LL_RECT,           // Logged-in userlist position         RECT *
   W_PRO_SAVE_DESKTOP,      // Save desktop between sessions?      B
   W_PRO_WORDWRAP,          // Wrap long lines in Reader?          B
   W_PRO_POPOPTS,           // POP3 options - do not alter
   W_PRO_NO_TCP,            // If NZ, disable WINSOCK loading      B
   W_PRO_IDLE_CHECKS,       // Frequency of POP3 newmail checks    Integer secs
   W_PRO_NEWMAIL_CHECKS,    // Frequency of local newmail checks   Integer secs
   W_PRO_ORGANIZATION,      // Secondary organization name         char * [45]
   W_PRO_TIMEZONE,          // Secondary time zone setting         char * [6]
   W_PRO_NO_REQ_CONFIRM,    // Allow confirm reading (standalone)  B
   W_PRO_NFYMODE,           // Telltale window mode                0, 1, 2
   W_PRO_NFYSETTINGS,       // Do not alter.
   W_PRO_NFY_POS,           // Telltale window position            POINT *
   W_PRO_DLM_RECT,          // Distribution list manager position  RECT *
   W_PRO_NB_RECT,           // Noticeboard manager position        RECT *
   W_PRO_HPRINT,            // Header printing settings            0, 1, 2, 3
   W_PRO_XRECT,             // Extension manager position          RECT *
   W_PRO_NEWMAIL_SOUND,     // Newmail sound file                  char * [80]
   W_PRO_FOLMAN_RECT,       // Folder manager window position      RECT *
   W_PRO_OMIT_HEADERS,      // Omit headers flag for replies       B
   W_PRO_USE_CUSTOM_REPLY,  // Use/don't use custom reply format   B
   W_PRO_CUSTOM_REPLY,      // Format string for custom replies    char * [64]
   W_PRO_USE_8BIT,          // Use 8-bit MIME encodings            B
   W_PRO_FOLMANFONT,        // Folder Manager font                 FONTDEF *
   W_PRO_QUICKFOLDERS,      // Quick Folder array [6]              QUICKFOLDER *
   W_PRO_QUICKFOLDERFLAGS,  // Quick folder flags                  Char
   W_PRO_MHS_RECT,          // MHS Directory Service position      RECT *
   };

